# Little Bear Node.js Echo 

**DISCLAIMER**: This is not an officially supported Google product.

This is a sample server written in Node.js to handle bi-directional echo, integrating
with the [Google Standard Payments API](https://developers.google.com/standard-payments)
as well as the Partner echo API.

## Install
* [Node.js](https://nodejs.org/en/download/)
* [Google Cloud SDK](https://cloud.google.com/sdk/) (aka gcloud) If you wish to test on a Google App Engine instance

## Prerequisites
* A front end gateway has been configured to handle TLS termination (either Google App Engine or your own solution).
* The hostname(s) that are responsible for serving your Cache APIs have been
given to your Google contact.
* Public keys have been exchanged with your Google point of contact. 
* Google has provided you with a unique Payment Integrator Account ID (PIAID).
This PIAID will be used to uniquely identify the bank when making API requests 
to the Google Cache API.

To view these steps in more detail, please reference the
[Cache Implementation Steps](https://developers.google.com/pay/cache/banks/apis/payment-integrator-cache-fop-api/rest/v1/paycache/echo?hl=en).

## Running the server
1. In the project directory, run `npm install` to install dependencies.
2. Set up your keys in the project directory as follows. Add your ASCII armored PGP keys to the top level of the project directory in files named private.key and public.key. Then, add your private key passphrase to passphrase.txt.
3. Set the VERBOSE and PIAID constants in server.js. Google will provide you with your PIAID during the PGP key exchange process.
4. Set the ECHO_URL constants in server.js. The echo URL will differ depending on your integration. You can find the diagnostic echo URL for your service type in the API reference section on the developer site.
5. In the project directory, run one of the following commands:

  * `node server.js` to run the code locally
  * `gcloud app deploy` run it on a pre-configured AppEngine instance
  
6. Execute the HTTP post request to test Google Standard Payments echo API.

```shell
  $ curl -X POST -H 'Content-Type: text/plain' -d 'Hello from Little Bear' https://{HOSTNAME}/echo
```  
