// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.google.pay.echo.outbound.controller;

import com.google.pay.echo.outbound.service.OutboundEchoService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class OutboundEchoController {

  private final OutboundEchoService outboundEchoService;

  public OutboundEchoController(OutboundEchoService outboundEchoService) {
    this.outboundEchoService = outboundEchoService;
  }

  /**
   * POST endpoint that accepts a message, encrypts it, and relays it to the Google Standard
   * Payments sandbox service.
   *
   * @param message The message to be relayed to the GSP sandbox service.
   * @return The decrypted message returned from the GSP POST request.
   */
  @PostMapping(value = "/echo", consumes = "text/plain")
  public ResponseEntity<String> echo(@RequestBody String message) {
    return outboundEchoService.postBillPayNotificationEchoApi(message);
  }
}
