/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * A section of the price list containing one or more items.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Section extends com.google.api.client.json.GenericJson {

  /**
   * Items that are contained within this section of the price list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Item> items;

  /**
   * Required. Language-tagged labels for the section. We recommend that section names and
   * descriptions be 140 characters or less. At least one set of labels is required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Label> labels;

  /**
   * Required. ID for the section. Price list, section, and item IDs cannot be duplicated within
   * this Location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sectionId;

  /**
   * Optional. Type of the current price list section. Default value is FOOD.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sectionType;

  /**
   * Items that are contained within this section of the price list.
   * @return value or {@code null} for none
   */
  public java.util.List<Item> getItems() {
    return items;
  }

  /**
   * Items that are contained within this section of the price list.
   * @param items items or {@code null} for none
   */
  public Section setItems(java.util.List<Item> items) {
    this.items = items;
    return this;
  }

  /**
   * Required. Language-tagged labels for the section. We recommend that section names and
   * descriptions be 140 characters or less. At least one set of labels is required.
   * @return value or {@code null} for none
   */
  public java.util.List<Label> getLabels() {
    return labels;
  }

  /**
   * Required. Language-tagged labels for the section. We recommend that section names and
   * descriptions be 140 characters or less. At least one set of labels is required.
   * @param labels labels or {@code null} for none
   */
  public Section setLabels(java.util.List<Label> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * Required. ID for the section. Price list, section, and item IDs cannot be duplicated within
   * this Location.
   * @return value or {@code null} for none
   */
  public java.lang.String getSectionId() {
    return sectionId;
  }

  /**
   * Required. ID for the section. Price list, section, and item IDs cannot be duplicated within
   * this Location.
   * @param sectionId sectionId or {@code null} for none
   */
  public Section setSectionId(java.lang.String sectionId) {
    this.sectionId = sectionId;
    return this;
  }

  /**
   * Optional. Type of the current price list section. Default value is FOOD.
   * @return value or {@code null} for none
   */
  public java.lang.String getSectionType() {
    return sectionType;
  }

  /**
   * Optional. Type of the current price list section. Default value is FOOD.
   * @param sectionType sectionType or {@code null} for none
   */
  public Section setSectionType(java.lang.String sectionType) {
    this.sectionType = sectionType;
    return this;
  }

  @Override
  public Section set(String fieldName, Object value) {
    return (Section) super.set(fieldName, value);
  }

  @Override
  public Section clone() {
    return (Section) super.clone();
  }

}
