/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Physical distancing measures implemented by the hotel during COVID-19.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PhysicalDistancing extends com.google.api.client.json.GenericJson {

  /**
   * Common areas arranged to maintain physical distancing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean commonAreasPhysicalDistancingArranged;

  /**
   * Common areas physical distancing arranged exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String commonAreasPhysicalDistancingArrangedException;

  /**
   * Physical distancing required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean physicalDistancingRequired;

  /**
   * Physical distancing required exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String physicalDistancingRequiredException;

  /**
   * Safety dividers at front desk and other locations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean safetyDividers;

  /**
   * Safety dividers exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String safetyDividersException;

  /**
   * Guest occupancy limited within shared facilities.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean sharedAreasLimitedOccupancy;

  /**
   * Shared areas limited occupancy exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sharedAreasLimitedOccupancyException;

  /**
   * Private spaces designated in spa and wellness areas.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean wellnessAreasHavePrivateSpaces;

  /**
   * Wellness areas have private spaces exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String wellnessAreasHavePrivateSpacesException;

  /**
   * Common areas arranged to maintain physical distancing.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCommonAreasPhysicalDistancingArranged() {
    return commonAreasPhysicalDistancingArranged;
  }

  /**
   * Common areas arranged to maintain physical distancing.
   * @param commonAreasPhysicalDistancingArranged commonAreasPhysicalDistancingArranged or {@code null} for none
   */
  public PhysicalDistancing setCommonAreasPhysicalDistancingArranged(java.lang.Boolean commonAreasPhysicalDistancingArranged) {
    this.commonAreasPhysicalDistancingArranged = commonAreasPhysicalDistancingArranged;
    return this;
  }

  /**
   * Common areas physical distancing arranged exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getCommonAreasPhysicalDistancingArrangedException() {
    return commonAreasPhysicalDistancingArrangedException;
  }

  /**
   * Common areas physical distancing arranged exception.
   * @param commonAreasPhysicalDistancingArrangedException commonAreasPhysicalDistancingArrangedException or {@code null} for none
   */
  public PhysicalDistancing setCommonAreasPhysicalDistancingArrangedException(java.lang.String commonAreasPhysicalDistancingArrangedException) {
    this.commonAreasPhysicalDistancingArrangedException = commonAreasPhysicalDistancingArrangedException;
    return this;
  }

  /**
   * Physical distancing required.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPhysicalDistancingRequired() {
    return physicalDistancingRequired;
  }

  /**
   * Physical distancing required.
   * @param physicalDistancingRequired physicalDistancingRequired or {@code null} for none
   */
  public PhysicalDistancing setPhysicalDistancingRequired(java.lang.Boolean physicalDistancingRequired) {
    this.physicalDistancingRequired = physicalDistancingRequired;
    return this;
  }

  /**
   * Physical distancing required exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getPhysicalDistancingRequiredException() {
    return physicalDistancingRequiredException;
  }

  /**
   * Physical distancing required exception.
   * @param physicalDistancingRequiredException physicalDistancingRequiredException or {@code null} for none
   */
  public PhysicalDistancing setPhysicalDistancingRequiredException(java.lang.String physicalDistancingRequiredException) {
    this.physicalDistancingRequiredException = physicalDistancingRequiredException;
    return this;
  }

  /**
   * Safety dividers at front desk and other locations.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSafetyDividers() {
    return safetyDividers;
  }

  /**
   * Safety dividers at front desk and other locations.
   * @param safetyDividers safetyDividers or {@code null} for none
   */
  public PhysicalDistancing setSafetyDividers(java.lang.Boolean safetyDividers) {
    this.safetyDividers = safetyDividers;
    return this;
  }

  /**
   * Safety dividers exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getSafetyDividersException() {
    return safetyDividersException;
  }

  /**
   * Safety dividers exception.
   * @param safetyDividersException safetyDividersException or {@code null} for none
   */
  public PhysicalDistancing setSafetyDividersException(java.lang.String safetyDividersException) {
    this.safetyDividersException = safetyDividersException;
    return this;
  }

  /**
   * Guest occupancy limited within shared facilities.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSharedAreasLimitedOccupancy() {
    return sharedAreasLimitedOccupancy;
  }

  /**
   * Guest occupancy limited within shared facilities.
   * @param sharedAreasLimitedOccupancy sharedAreasLimitedOccupancy or {@code null} for none
   */
  public PhysicalDistancing setSharedAreasLimitedOccupancy(java.lang.Boolean sharedAreasLimitedOccupancy) {
    this.sharedAreasLimitedOccupancy = sharedAreasLimitedOccupancy;
    return this;
  }

  /**
   * Shared areas limited occupancy exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getSharedAreasLimitedOccupancyException() {
    return sharedAreasLimitedOccupancyException;
  }

  /**
   * Shared areas limited occupancy exception.
   * @param sharedAreasLimitedOccupancyException sharedAreasLimitedOccupancyException or {@code null} for none
   */
  public PhysicalDistancing setSharedAreasLimitedOccupancyException(java.lang.String sharedAreasLimitedOccupancyException) {
    this.sharedAreasLimitedOccupancyException = sharedAreasLimitedOccupancyException;
    return this;
  }

  /**
   * Private spaces designated in spa and wellness areas.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getWellnessAreasHavePrivateSpaces() {
    return wellnessAreasHavePrivateSpaces;
  }

  /**
   * Private spaces designated in spa and wellness areas.
   * @param wellnessAreasHavePrivateSpaces wellnessAreasHavePrivateSpaces or {@code null} for none
   */
  public PhysicalDistancing setWellnessAreasHavePrivateSpaces(java.lang.Boolean wellnessAreasHavePrivateSpaces) {
    this.wellnessAreasHavePrivateSpaces = wellnessAreasHavePrivateSpaces;
    return this;
  }

  /**
   * Wellness areas have private spaces exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getWellnessAreasHavePrivateSpacesException() {
    return wellnessAreasHavePrivateSpacesException;
  }

  /**
   * Wellness areas have private spaces exception.
   * @param wellnessAreasHavePrivateSpacesException wellnessAreasHavePrivateSpacesException or {@code null} for none
   */
  public PhysicalDistancing setWellnessAreasHavePrivateSpacesException(java.lang.String wellnessAreasHavePrivateSpacesException) {
    this.wellnessAreasHavePrivateSpacesException = wellnessAreasHavePrivateSpacesException;
    return this;
  }

  @Override
  public PhysicalDistancing set(String fieldName, Object value) {
    return (PhysicalDistancing) super.set(fieldName, value);
  }

  @Override
  public PhysicalDistancing clone() {
    return (PhysicalDistancing) super.clone();
  }

}
