/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * The time periods during which a location is open for certain types of business.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MoreHours extends com.google.api.client.json.GenericJson {

  /**
   * Required. Type of hours. Clients should call {#link businessCategories:BatchGet} to get
   * supported hours types for categories of their locations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hoursTypeId;

  /**
   * Required. A collection of times that this location is open. Each period represents a range of
   * hours when the location is open during the week.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TimePeriod> periods;

  static {
    // hack to force ProGuard to consider TimePeriod used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(TimePeriod.class);
  }

  /**
   * Required. Type of hours. Clients should call {#link businessCategories:BatchGet} to get
   * supported hours types for categories of their locations.
   * @return value or {@code null} for none
   */
  public java.lang.String getHoursTypeId() {
    return hoursTypeId;
  }

  /**
   * Required. Type of hours. Clients should call {#link businessCategories:BatchGet} to get
   * supported hours types for categories of their locations.
   * @param hoursTypeId hoursTypeId or {@code null} for none
   */
  public MoreHours setHoursTypeId(java.lang.String hoursTypeId) {
    this.hoursTypeId = hoursTypeId;
    return this;
  }

  /**
   * Required. A collection of times that this location is open. Each period represents a range of
   * hours when the location is open during the week.
   * @return value or {@code null} for none
   */
  public java.util.List<TimePeriod> getPeriods() {
    return periods;
  }

  /**
   * Required. A collection of times that this location is open. Each period represents a range of
   * hours when the location is open during the week.
   * @param periods periods or {@code null} for none
   */
  public MoreHours setPeriods(java.util.List<TimePeriod> periods) {
    this.periods = periods;
    return this;
  }

  @Override
  public MoreHours set(String fieldName, Object value) {
    return (MoreHours) super.set(fieldName, value);
  }

  @Override
  public MoreHours clone() {
    return (MoreHours) super.clone();
  }

}
