/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Represents a [local post](https://support.google.com/business/answer/7662907) for a location.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LocalPost extends com.google.api.client.json.GenericJson {

  /**
   * The type of alert the post is created for. This field is only applicable for posts of
   * topic_type Alert, and behaves as a sub-type of Alerts.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String alertType;

  /**
   * The URL that users are sent to when clicking through the promotion. Ignored for topic type
   * `OFFER`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CallToAction callToAction;

  /**
   * Output only. Time of the creation of the post.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Event information. Required for topic types `EVENT` and `OFFER`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalPostEvent event;

  /**
   * The language of the local post.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String languageCode;

  /**
   * The media associated with the post. source_url is the only supported data field for a LocalPost
   * MediaItem.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MediaItem> media;

  /**
   * Output only. Google identifier for this local post in the form:
   * `accounts/{account_id}/locations/{location_id}/localPosts/{local_post_id}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Additional data for offer posts. This should only be set when the topic_type is OFFER.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalPostOffer offer;

  /**
   * Output only. The link to the local post in Google search. This link can be used to share the
   * post via social media, email, text, etc.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String searchUrl;

  /**
   * Output only. The state of the post, indicating what part of its lifecycle it is in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Description/body of the local post.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String summary;

  /**
   * Required. The topic type of the post: standard, event, offer, or alert.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String topicType;

  /**
   * Output only. Time of the last modification of the post made by the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateTime;

  /**
   * The type of alert the post is created for. This field is only applicable for posts of
   * topic_type Alert, and behaves as a sub-type of Alerts.
   * @return value or {@code null} for none
   */
  public java.lang.String getAlertType() {
    return alertType;
  }

  /**
   * The type of alert the post is created for. This field is only applicable for posts of
   * topic_type Alert, and behaves as a sub-type of Alerts.
   * @param alertType alertType or {@code null} for none
   */
  public LocalPost setAlertType(java.lang.String alertType) {
    this.alertType = alertType;
    return this;
  }

  /**
   * The URL that users are sent to when clicking through the promotion. Ignored for topic type
   * `OFFER`.
   * @return value or {@code null} for none
   */
  public CallToAction getCallToAction() {
    return callToAction;
  }

  /**
   * The URL that users are sent to when clicking through the promotion. Ignored for topic type
   * `OFFER`.
   * @param callToAction callToAction or {@code null} for none
   */
  public LocalPost setCallToAction(CallToAction callToAction) {
    this.callToAction = callToAction;
    return this;
  }

  /**
   * Output only. Time of the creation of the post.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. Time of the creation of the post.
   * @param createTime createTime or {@code null} for none
   */
  public LocalPost setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Event information. Required for topic types `EVENT` and `OFFER`.
   * @return value or {@code null} for none
   */
  public LocalPostEvent getEvent() {
    return event;
  }

  /**
   * Event information. Required for topic types `EVENT` and `OFFER`.
   * @param event event or {@code null} for none
   */
  public LocalPost setEvent(LocalPostEvent event) {
    this.event = event;
    return this;
  }

  /**
   * The language of the local post.
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguageCode() {
    return languageCode;
  }

  /**
   * The language of the local post.
   * @param languageCode languageCode or {@code null} for none
   */
  public LocalPost setLanguageCode(java.lang.String languageCode) {
    this.languageCode = languageCode;
    return this;
  }

  /**
   * The media associated with the post. source_url is the only supported data field for a LocalPost
   * MediaItem.
   * @return value or {@code null} for none
   */
  public java.util.List<MediaItem> getMedia() {
    return media;
  }

  /**
   * The media associated with the post. source_url is the only supported data field for a LocalPost
   * MediaItem.
   * @param media media or {@code null} for none
   */
  public LocalPost setMedia(java.util.List<MediaItem> media) {
    this.media = media;
    return this;
  }

  /**
   * Output only. Google identifier for this local post in the form:
   * `accounts/{account_id}/locations/{location_id}/localPosts/{local_post_id}`
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. Google identifier for this local post in the form:
   * `accounts/{account_id}/locations/{location_id}/localPosts/{local_post_id}`
   * @param name name or {@code null} for none
   */
  public LocalPost setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Additional data for offer posts. This should only be set when the topic_type is OFFER.
   * @return value or {@code null} for none
   */
  public LocalPostOffer getOffer() {
    return offer;
  }

  /**
   * Additional data for offer posts. This should only be set when the topic_type is OFFER.
   * @param offer offer or {@code null} for none
   */
  public LocalPost setOffer(LocalPostOffer offer) {
    this.offer = offer;
    return this;
  }

  /**
   * Output only. The link to the local post in Google search. This link can be used to share the
   * post via social media, email, text, etc.
   * @return value or {@code null} for none
   */
  public java.lang.String getSearchUrl() {
    return searchUrl;
  }

  /**
   * Output only. The link to the local post in Google search. This link can be used to share the
   * post via social media, email, text, etc.
   * @param searchUrl searchUrl or {@code null} for none
   */
  public LocalPost setSearchUrl(java.lang.String searchUrl) {
    this.searchUrl = searchUrl;
    return this;
  }

  /**
   * Output only. The state of the post, indicating what part of its lifecycle it is in.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * Output only. The state of the post, indicating what part of its lifecycle it is in.
   * @param state state or {@code null} for none
   */
  public LocalPost setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * Description/body of the local post.
   * @return value or {@code null} for none
   */
  public java.lang.String getSummary() {
    return summary;
  }

  /**
   * Description/body of the local post.
   * @param summary summary or {@code null} for none
   */
  public LocalPost setSummary(java.lang.String summary) {
    this.summary = summary;
    return this;
  }

  /**
   * Required. The topic type of the post: standard, event, offer, or alert.
   * @return value or {@code null} for none
   */
  public java.lang.String getTopicType() {
    return topicType;
  }

  /**
   * Required. The topic type of the post: standard, event, offer, or alert.
   * @param topicType topicType or {@code null} for none
   */
  public LocalPost setTopicType(java.lang.String topicType) {
    this.topicType = topicType;
    return this;
  }

  /**
   * Output only. Time of the last modification of the post made by the user.
   * @return value or {@code null} for none
   */
  public String getUpdateTime() {
    return updateTime;
  }

  /**
   * Output only. Time of the last modification of the post made by the user.
   * @param updateTime updateTime or {@code null} for none
   */
  public LocalPost setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  @Override
  public LocalPost set(String fieldName, Object value) {
    return (LocalPost) super.set(fieldName, value);
  }

  @Override
  public LocalPost clone() {
    return (LocalPost) super.clone();
  }

}
