/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Section of a menu. It can contain multiple items/dishes.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FoodMenuSection extends com.google.api.client.json.GenericJson {

  /**
   * Required. Items of the section. Each Section must have at least an item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FoodMenuItem> items;

  static {
    // hack to force ProGuard to consider FoodMenuItem used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(FoodMenuItem.class);
  }

  /**
   * Required. Language tagged labels for this menu section. Display names should be 140 characters
   * or less, with descriptions 1,000 characters or less. At least one set of labels is required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MenuLabel> labels;

  static {
    // hack to force ProGuard to consider MenuLabel used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(MenuLabel.class);
  }

  /**
   * Required. Items of the section. Each Section must have at least an item.
   * @return value or {@code null} for none
   */
  public java.util.List<FoodMenuItem> getItems() {
    return items;
  }

  /**
   * Required. Items of the section. Each Section must have at least an item.
   * @param items items or {@code null} for none
   */
  public FoodMenuSection setItems(java.util.List<FoodMenuItem> items) {
    this.items = items;
    return this;
  }

  /**
   * Required. Language tagged labels for this menu section. Display names should be 140 characters
   * or less, with descriptions 1,000 characters or less. At least one set of labels is required.
   * @return value or {@code null} for none
   */
  public java.util.List<MenuLabel> getLabels() {
    return labels;
  }

  /**
   * Required. Language tagged labels for this menu section. Display names should be 140 characters
   * or less, with descriptions 1,000 characters or less. At least one set of labels is required.
   * @param labels labels or {@code null} for none
   */
  public FoodMenuSection setLabels(java.util.List<MenuLabel> labels) {
    this.labels = labels;
    return this;
  }

  @Override
  public FoodMenuSection set(String fieldName, Object value) {
    return (FoodMenuSection) super.set(fieldName, value);
  }

  @Override
  public FoodMenuSection clone() {
    return (FoodMenuSection) super.clone();
  }

}
