/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Represents an answer to a question
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Answer extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The author of the answer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Author author;

  /**
   * Output only. The timestamp for when the answer was written.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Output only. The unique name for the answer accounts/locations/questions/answers
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The text of the answer. It should contain at least one non-whitespace character. The maximum
   * length is 4096 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String text;

  /**
   * Output only. The timestamp for when the answer was last modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateTime;

  /**
   * Output only. The number of upvotes for the answer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer upvoteCount;

  /**
   * Output only. The author of the answer.
   * @return value or {@code null} for none
   */
  public Author getAuthor() {
    return author;
  }

  /**
   * Output only. The author of the answer.
   * @param author author or {@code null} for none
   */
  public Answer setAuthor(Author author) {
    this.author = author;
    return this;
  }

  /**
   * Output only. The timestamp for when the answer was written.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. The timestamp for when the answer was written.
   * @param createTime createTime or {@code null} for none
   */
  public Answer setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Output only. The unique name for the answer accounts/locations/questions/answers
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. The unique name for the answer accounts/locations/questions/answers
   * @param name name or {@code null} for none
   */
  public Answer setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The text of the answer. It should contain at least one non-whitespace character. The maximum
   * length is 4096 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getText() {
    return text;
  }

  /**
   * The text of the answer. It should contain at least one non-whitespace character. The maximum
   * length is 4096 characters.
   * @param text text or {@code null} for none
   */
  public Answer setText(java.lang.String text) {
    this.text = text;
    return this;
  }

  /**
   * Output only. The timestamp for when the answer was last modified.
   * @return value or {@code null} for none
   */
  public String getUpdateTime() {
    return updateTime;
  }

  /**
   * Output only. The timestamp for when the answer was last modified.
   * @param updateTime updateTime or {@code null} for none
   */
  public Answer setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  /**
   * Output only. The number of upvotes for the answer.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getUpvoteCount() {
    return upvoteCount;
  }

  /**
   * Output only. The number of upvotes for the answer.
   * @param upvoteCount upvoteCount or {@code null} for none
   */
  public Answer setUpvoteCount(java.lang.Integer upvoteCount) {
    this.upvoteCount = upvoteCount;
    return this;
  }

  @Override
  public Answer set(String fieldName, Object value) {
    return (Answer) super.set(fieldName, value);
  }

  @Override
  public Answer clone() {
    return (Answer) super.clone();
  }

}
