/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Request message for reporting a GoogleLocation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReportGoogleLocationRequest extends com.google.api.client.json.GenericJson {

  /**
   * Optional. The resource name of the location group that this Google Location is being reported
   * for, in the format `accounts/{account_id}`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String locationGroupName;

  /**
   * The reason for which the user is reporting this location when the issue is with the location
   * itself.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reportReasonBadLocation;

  /**
   * The reason for which the user is reporting this location when the issue is with the
   * recommendation. This report is useful if the location has been recommended to the GMB account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reportReasonBadRecommendation;

  /**
   * Optional. A text entry for elaborating on the reason for which the user is reporting this
   * location. The maximum length is 512 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reportReasonElaboration;

  /**
   * Optional. The BCP 47 code of language used in `report_reason_elaboration`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reportReasonLanguageCode;

  /**
   * Optional. The resource name of the location group that this Google Location is being reported
   * for, in the format `accounts/{account_id}`.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocationGroupName() {
    return locationGroupName;
  }

  /**
   * Optional. The resource name of the location group that this Google Location is being reported
   * for, in the format `accounts/{account_id}`.
   * @param locationGroupName locationGroupName or {@code null} for none
   */
  public ReportGoogleLocationRequest setLocationGroupName(java.lang.String locationGroupName) {
    this.locationGroupName = locationGroupName;
    return this;
  }

  /**
   * The reason for which the user is reporting this location when the issue is with the location
   * itself.
   * @return value or {@code null} for none
   */
  public java.lang.String getReportReasonBadLocation() {
    return reportReasonBadLocation;
  }

  /**
   * The reason for which the user is reporting this location when the issue is with the location
   * itself.
   * @param reportReasonBadLocation reportReasonBadLocation or {@code null} for none
   */
  public ReportGoogleLocationRequest setReportReasonBadLocation(java.lang.String reportReasonBadLocation) {
    this.reportReasonBadLocation = reportReasonBadLocation;
    return this;
  }

  /**
   * The reason for which the user is reporting this location when the issue is with the
   * recommendation. This report is useful if the location has been recommended to the GMB account.
   * @return value or {@code null} for none
   */
  public java.lang.String getReportReasonBadRecommendation() {
    return reportReasonBadRecommendation;
  }

  /**
   * The reason for which the user is reporting this location when the issue is with the
   * recommendation. This report is useful if the location has been recommended to the GMB account.
   * @param reportReasonBadRecommendation reportReasonBadRecommendation or {@code null} for none
   */
  public ReportGoogleLocationRequest setReportReasonBadRecommendation(java.lang.String reportReasonBadRecommendation) {
    this.reportReasonBadRecommendation = reportReasonBadRecommendation;
    return this;
  }

  /**
   * Optional. A text entry for elaborating on the reason for which the user is reporting this
   * location. The maximum length is 512 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getReportReasonElaboration() {
    return reportReasonElaboration;
  }

  /**
   * Optional. A text entry for elaborating on the reason for which the user is reporting this
   * location. The maximum length is 512 characters.
   * @param reportReasonElaboration reportReasonElaboration or {@code null} for none
   */
  public ReportGoogleLocationRequest setReportReasonElaboration(java.lang.String reportReasonElaboration) {
    this.reportReasonElaboration = reportReasonElaboration;
    return this;
  }

  /**
   * Optional. The BCP 47 code of language used in `report_reason_elaboration`.
   * @return value or {@code null} for none
   */
  public java.lang.String getReportReasonLanguageCode() {
    return reportReasonLanguageCode;
  }

  /**
   * Optional. The BCP 47 code of language used in `report_reason_elaboration`.
   * @param reportReasonLanguageCode reportReasonLanguageCode or {@code null} for none
   */
  public ReportGoogleLocationRequest setReportReasonLanguageCode(java.lang.String reportReasonLanguageCode) {
    this.reportReasonLanguageCode = reportReasonLanguageCode;
    return this;
  }

  @Override
  public ReportGoogleLocationRequest set(String fieldName, Object value) {
    return (ReportGoogleLocationRequest) super.set(fieldName, value);
  }

  @Override
  public ReportGoogleLocationRequest clone() {
    return (ReportGoogleLocationRequest) super.clone();
  }

}
