/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Physical adaptations made to the property in consideration of varying levels of human physical
 * ability.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Accessibility extends com.google.api.client.json.GenericJson {

  /**
   * Mobility accessible. Throughout the property there are physical adaptations to ease the stay of
   * a person in a wheelchair, such as auto-opening doors, wide elevators, wide bathrooms or ramps.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean mobilityAccessible;

  /**
   * Mobility accessible elevator. A lift that transports people from one level to another and is
   * built to accommodate a wheelchair-using passenger owing to the width of its doors and placement
   * of call buttons.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean mobilityAccessibleElevator;

  /**
   * Mobility accessible elevator exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mobilityAccessibleElevatorException;

  /**
   * Mobility accessible exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mobilityAccessibleException;

  /**
   * Mobility accessible parking. The presence of a marked, designated area of prescribed size in
   * which only registered, labeled vehicles transporting a person with physical challenges may
   * park.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean mobilityAccessibleParking;

  /**
   * Mobility accessible parking exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mobilityAccessibleParkingException;

  /**
   * Mobility accessible pool. A swimming pool equipped with a mechanical chair that can be lowered
   * and raised for the purpose of moving physically challenged guests into and out of the pool. May
   * be powered by electricity or water. Also known as pool lift.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean mobilityAccessiblePool;

  /**
   * Mobility accessible pool exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mobilityAccessiblePoolException;

  /**
   * Mobility accessible. Throughout the property there are physical adaptations to ease the stay of
   * a person in a wheelchair, such as auto-opening doors, wide elevators, wide bathrooms or ramps.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getMobilityAccessible() {
    return mobilityAccessible;
  }

  /**
   * Mobility accessible. Throughout the property there are physical adaptations to ease the stay of
   * a person in a wheelchair, such as auto-opening doors, wide elevators, wide bathrooms or ramps.
   * @param mobilityAccessible mobilityAccessible or {@code null} for none
   */
  public Accessibility setMobilityAccessible(java.lang.Boolean mobilityAccessible) {
    this.mobilityAccessible = mobilityAccessible;
    return this;
  }

  /**
   * Mobility accessible elevator. A lift that transports people from one level to another and is
   * built to accommodate a wheelchair-using passenger owing to the width of its doors and placement
   * of call buttons.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getMobilityAccessibleElevator() {
    return mobilityAccessibleElevator;
  }

  /**
   * Mobility accessible elevator. A lift that transports people from one level to another and is
   * built to accommodate a wheelchair-using passenger owing to the width of its doors and placement
   * of call buttons.
   * @param mobilityAccessibleElevator mobilityAccessibleElevator or {@code null} for none
   */
  public Accessibility setMobilityAccessibleElevator(java.lang.Boolean mobilityAccessibleElevator) {
    this.mobilityAccessibleElevator = mobilityAccessibleElevator;
    return this;
  }

  /**
   * Mobility accessible elevator exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getMobilityAccessibleElevatorException() {
    return mobilityAccessibleElevatorException;
  }

  /**
   * Mobility accessible elevator exception.
   * @param mobilityAccessibleElevatorException mobilityAccessibleElevatorException or {@code null} for none
   */
  public Accessibility setMobilityAccessibleElevatorException(java.lang.String mobilityAccessibleElevatorException) {
    this.mobilityAccessibleElevatorException = mobilityAccessibleElevatorException;
    return this;
  }

  /**
   * Mobility accessible exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getMobilityAccessibleException() {
    return mobilityAccessibleException;
  }

  /**
   * Mobility accessible exception.
   * @param mobilityAccessibleException mobilityAccessibleException or {@code null} for none
   */
  public Accessibility setMobilityAccessibleException(java.lang.String mobilityAccessibleException) {
    this.mobilityAccessibleException = mobilityAccessibleException;
    return this;
  }

  /**
   * Mobility accessible parking. The presence of a marked, designated area of prescribed size in
   * which only registered, labeled vehicles transporting a person with physical challenges may
   * park.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getMobilityAccessibleParking() {
    return mobilityAccessibleParking;
  }

  /**
   * Mobility accessible parking. The presence of a marked, designated area of prescribed size in
   * which only registered, labeled vehicles transporting a person with physical challenges may
   * park.
   * @param mobilityAccessibleParking mobilityAccessibleParking or {@code null} for none
   */
  public Accessibility setMobilityAccessibleParking(java.lang.Boolean mobilityAccessibleParking) {
    this.mobilityAccessibleParking = mobilityAccessibleParking;
    return this;
  }

  /**
   * Mobility accessible parking exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getMobilityAccessibleParkingException() {
    return mobilityAccessibleParkingException;
  }

  /**
   * Mobility accessible parking exception.
   * @param mobilityAccessibleParkingException mobilityAccessibleParkingException or {@code null} for none
   */
  public Accessibility setMobilityAccessibleParkingException(java.lang.String mobilityAccessibleParkingException) {
    this.mobilityAccessibleParkingException = mobilityAccessibleParkingException;
    return this;
  }

  /**
   * Mobility accessible pool. A swimming pool equipped with a mechanical chair that can be lowered
   * and raised for the purpose of moving physically challenged guests into and out of the pool. May
   * be powered by electricity or water. Also known as pool lift.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getMobilityAccessiblePool() {
    return mobilityAccessiblePool;
  }

  /**
   * Mobility accessible pool. A swimming pool equipped with a mechanical chair that can be lowered
   * and raised for the purpose of moving physically challenged guests into and out of the pool. May
   * be powered by electricity or water. Also known as pool lift.
   * @param mobilityAccessiblePool mobilityAccessiblePool or {@code null} for none
   */
  public Accessibility setMobilityAccessiblePool(java.lang.Boolean mobilityAccessiblePool) {
    this.mobilityAccessiblePool = mobilityAccessiblePool;
    return this;
  }

  /**
   * Mobility accessible pool exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getMobilityAccessiblePoolException() {
    return mobilityAccessiblePoolException;
  }

  /**
   * Mobility accessible pool exception.
   * @param mobilityAccessiblePoolException mobilityAccessiblePoolException or {@code null} for none
   */
  public Accessibility setMobilityAccessiblePoolException(java.lang.String mobilityAccessiblePoolException) {
    this.mobilityAccessiblePoolException = mobilityAccessiblePoolException;
    return this;
  }

  @Override
  public Accessibility set(String fieldName, Object value) {
    return (Accessibility) super.set(fieldName, value);
  }

  @Override
  public Accessibility clone() {
    return (Accessibility) super.clone();
  }

}
