/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * A region with its associated request count.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RegionCount extends com.google.api.client.json.GenericJson {

  /**
   * Number of driving-direction requests from this region.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long count;

  /**
   * Human-readable label for the region.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String label;

  /**
   * Center of region.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LatLng latlng;

  /**
   * Number of driving-direction requests from this region.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCount() {
    return count;
  }

  /**
   * Number of driving-direction requests from this region.
   * @param count count or {@code null} for none
   */
  public RegionCount setCount(java.lang.Long count) {
    this.count = count;
    return this;
  }

  /**
   * Human-readable label for the region.
   * @return value or {@code null} for none
   */
  public java.lang.String getLabel() {
    return label;
  }

  /**
   * Human-readable label for the region.
   * @param label label or {@code null} for none
   */
  public RegionCount setLabel(java.lang.String label) {
    this.label = label;
    return this;
  }

  /**
   * Center of region.
   * @return value or {@code null} for none
   */
  public LatLng getLatlng() {
    return latlng;
  }

  /**
   * Center of region.
   * @param latlng latlng or {@code null} for none
   */
  public RegionCount setLatlng(LatLng latlng) {
    this.latlng = latlng;
    return this;
  }

  @Override
  public RegionCount set(String fieldName, Object value) {
    return (RegionCount) super.set(fieldName, value);
  }

  @Override
  public RegionCount clone() {
    return (RegionCount) super.clone();
  }

}
