/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Additional non-user-editable information about the location.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Metadata extends com.google.api.client.json.GenericJson {

  /**
   * Information about the location that this location duplicates. Only present when
   * `location_state.is_duplicate` is true. Deprecated: We are no longer supporting detailed
   * information for duplicates.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Duplicate duplicate;

  /**
   * A link to the location on Maps.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mapsUrl;

  /**
   * A link to the page on Google Search where a customer can leave a review for the location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String newReviewUrl;

  /**
   * Information about the location that this location duplicates. Only present when
   * `location_state.is_duplicate` is true. Deprecated: We are no longer supporting detailed
   * information for duplicates.
   * @return value or {@code null} for none
   */
  public Duplicate getDuplicate() {
    return duplicate;
  }

  /**
   * Information about the location that this location duplicates. Only present when
   * `location_state.is_duplicate` is true. Deprecated: We are no longer supporting detailed
   * information for duplicates.
   * @param duplicate duplicate or {@code null} for none
   */
  public Metadata setDuplicate(Duplicate duplicate) {
    this.duplicate = duplicate;
    return this;
  }

  /**
   * A link to the location on Maps.
   * @return value or {@code null} for none
   */
  public java.lang.String getMapsUrl() {
    return mapsUrl;
  }

  /**
   * A link to the location on Maps.
   * @param mapsUrl mapsUrl or {@code null} for none
   */
  public Metadata setMapsUrl(java.lang.String mapsUrl) {
    this.mapsUrl = mapsUrl;
    return this;
  }

  /**
   * A link to the page on Google Search where a customer can leave a review for the location.
   * @return value or {@code null} for none
   */
  public java.lang.String getNewReviewUrl() {
    return newReviewUrl;
  }

  /**
   * A link to the page on Google Search where a customer can leave a review for the location.
   * @param newReviewUrl newReviewUrl or {@code null} for none
   */
  public Metadata setNewReviewUrl(java.lang.String newReviewUrl) {
    this.newReviewUrl = newReviewUrl;
    return this;
  }

  @Override
  public Metadata set(String fieldName, Object value) {
    return (Metadata) super.set(fieldName, value);
  }

  @Override
  public Metadata clone() {
    return (Metadata) super.clone();
  }

}
